﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
using UnityEngine.SceneManagement;
using hive;

public class Permission : MonoBehaviour {

	// delegate format
	public delegate void onPermissionEvent(bool isSuccess);


	// delegate list
	static onPermissionEvent onPermissionResult;



	public GameObject m_panel;
	public GameObject[] permissions;

	public Sprite spritePermissionCamera;
	public Sprite spritePermissionContacts;
	public Sprite spritePermissionPhone;
	public Sprite spritePermissionPhotoAlbum;
	public Sprite spritePermissionPush;
	public Sprite spritePermissionStorage;

	public Text title;

	// Use this for initialization
	void Start () {
		Debug.Log ("Permission Start");
	}

	public void getPermissionData(onPermissionEvent listener) {
			onPermissionResult = listener;
			HIVEManager.shared.requestPermissionViewData(onHIVEManagerRequestPermissionEvent);
	}


	public void setPermissionDatas(string contents, List<PermissionViewUnitData> permissionDatas) 
	{
		Debug.Log("setPermissionDatas ");

		if (contents != "") {
			title.text = contents;
		}
		int permissionDataCnt = permissionDatas.Count;
		int permissionUICnt = permissions.Length;

		
		if (permissionUICnt < permissionDataCnt) {
			permissionDataCnt = permissionUICnt;
		} else if (permissionUICnt > permissionDataCnt) {
			for (int i = permissionDataCnt ; i < permissionUICnt; i++) {


			GameObject nowPermission = permissions[i];
			nowPermission.SetActive(false);
			}
		}

		for (int i = 0 ; i < permissionDataCnt; i++ ) {
			Debug.Log("Permission Datas " + i);
			PermissionViewUnitData permission = permissionDatas[i];


			GameObject nowPermission = permissions[i];
			Image permissionImg = nowPermission.transform.Find("Image").GetComponent<Image>();
			Text permissionTitle = nowPermission.transform.Find("title").GetComponent<Text>();
			Text permissionBody = nowPermission.transform.Find("body").GetComponent<Text>();

			permissionTitle.text = permission.title;
			permissionBody.text = permission.contents;
			// buttonStart.GetComponent<Image>().sprite = isGameSignIn ? spriteStart : spriteLogin;

			switch(permission.permissionCategory) {
				case PermissionViewPermissionCategory.Photo:
				permissionImg.GetComponent<Image>().sprite = spritePermissionPhotoAlbum;
				break;
				case PermissionViewPermissionCategory.Camera:
				permissionImg.GetComponent<Image>().sprite = spritePermissionCamera;
				break;
				case PermissionViewPermissionCategory.Push:
				permissionImg.GetComponent<Image>().sprite = spritePermissionPush;
				break;
				case PermissionViewPermissionCategory.Storage:
				permissionImg.GetComponent<Image>().sprite = spritePermissionStorage;
				break;
				case PermissionViewPermissionCategory.Phone:
				permissionImg.GetComponent<Image>().sprite = spritePermissionPhone;
				break;
				case PermissionViewPermissionCategory.Contacts:
				permissionImg.GetComponent<Image>().sprite = spritePermissionContacts;
				break;
			}
		}

	}

	public void closePermissionPanel()
	{
		Debug.Log("closePermissionPanel");
		HIVEManager.shared.isPermissionAgreed = true;
		m_panel.SetActive(false);
		onPermissionResult(true);
	}

	// HIVE에서 호출 후 전달받는 콜백
	void onHIVEManagerRequestPermissionEvent(bool isNeedToShow, string message, PermissionViewData data) {
		if (isNeedToShow) {
			if (data != null) {
				Debug.Log("Permission need to show");
				onPermissionResult(false);
				m_panel.SetActive(true);
				setPermissionDatas(data.contents, data.permissions);
			} else {
				Debug.Log("Permission need to show but data is null");
				closePermissionPanel();
			}
		} else {
			// HomeManager.shared.onStartClick();
			Debug.Log("Permission need to skip");
			closePermissionPanel();
		}
	}
}
